<?php
$semRefrescamento = 1;
#include_once 'controlador/verificardorDeComprovativoDaVFS.controlador.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/vendor/autoload.php';

use Smalot\PdfParser\Parser;

define('TARGET_PRODUCER', "iTextSharp.LGPLv2.Core 1.7.0.0");

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['pdfFile'])) {
    $file = $_FILES['pdfFile']['tmp_name'];
    if (!empty($_POST["chave"])) {
        /* if (count((ControladorVerificardorDeComprovativoDaVFS::ctrMostrarCodigoPorEstado($_POST["chave"],"k"))) == 1) { */
          if (file_exists($file)) {
            try {
                $parser = new Parser();
                $pdf = $parser->parseFile($file);
  
                $details = $pdf->getDetails();
                $producer = $details['Producer'] ?? 'Não disponível';
  
                if ($producer === TARGET_PRODUCER) {
                    $message = "Comprovativo verdadeiro foi gerado pela VFS Global.";
                } else {
                    $message = "O documento não foi gerado pela VFS Global.";
                }
            } catch (Exception $e) {
                $message = "Erro ao processar o arquivo: " . $e->getMessage();
            }
        } else {
            $message = "Nenhum arquivo foi encontrado.";
        }
        /* }else {
          $message = "Erro: Esta Chave já foi utilizada.";
        } */
    }else {
      $message = "Erro: Leia as instruções a baixo e Solicite uma Chave.";
    }
    
} else {
    $message = "Envie um arquivo PDF para verificar.";
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar comprovativos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #333;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 700px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        h1 {
            text-align: center;
            color: #0056b3;
        }
        label {
            display: block;
            margin: 20px 0 10px;
            font-weight: bold;
            color: #333;
        }
        input[type="file"], input[type="text"] {
            padding: 10px;
            width: 100%;
            margin-bottom: 20px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }
        button {
            margin-top: 20px;
            padding: 10px 20px;
            border: none;
            background-color: #0056b3;
            color: white;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
        }
        button:hover {
            background-color: #003d80;
        }
        .message {
            margin-top: 20px;
            padding: 10px;
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c8e6c9;
            border-radius: 4px;
        }
        .message.error {
            background: #ffebee;
            color: #c62828;
            border: 1px solid #ffcdd2;
        }
        .instructions {
            margin-top: 30px;
            padding: 20px;
            background: #f9f9f9;
            border-radius: 8px;
            color: #333;
        }
        .instructions h2 {
            margin-top: 0;
            color: #0056b3;
        }
        .instructions ol {
            padding-left: 20px;
        }
        .instructions ol li {
            margin-bottom: 10px;
        }
        .sponsors {
            display: flex;
            justify-content: space-between;
            gap: 20px;
            margin: 30px 0;
        }
        .sponsor {
            flex: 1;
            padding: 20px;
            background: linear-gradient(135deg, #333,#333);
            border-radius: 12px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            color: #333;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        .sponsor:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        }
        .sponsor img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            margin-bottom: 10px;
            border: 2px solid #ccc;
        }
        .sponsor p {
            margin: 10px 0 0;
            font-size: 1.1em;
            font-weight: bold;
        }
        .socials {
            margin-top: 40px;
            text-align: center;
        }
        .socials a {
            margin: 0 10px;
            text-decoration: none;
            display: inline-block;
        }
        .socials a img {
            width: 40px;
            height: 40px;
            transition: transform 0.3s;
        }
        .socials a img:hover {
            transform: scale(1.2);
        }
    </style>
</head>
<body>
    <div class="container">
        <center><h2>Verificador de comprovativos de Agendamento em PDF <br>VFS Global</h2></center>
        <form method="post" enctype="multipart/form-data">
            <label for="chave">Chave:</label>
            <input type="text" name="chave" id="chave" style="text-align: center;" placeholder="Insira a chave de verificação">

            <label for="pdfFile">Selecione um comprovativo em PDF:</label>
            <input type="file" name="pdfFile" id="pdfFile" accept="application/pdf">
            
            
            
            <button type="submit">Verificar</button>
            
            <?php if (!empty($message)): ?>
            <div class="message <?= strpos($message, 'Erro') !== false || strpos($message, 'não foi gerado') !== false ? 'error' : '' ?>">
                <?= htmlspecialchars($message) ?>
            </div>
            <?php endif; ?>
        </form>

        <div class="instructions">
            <h2 style="color: #c62828;"><center>Preço da Senha: <b>2.000 Akz</b></center></h2>
            <h2>Instruções para Verificação:</h2>
            <ol>
                <li>Faça a transferencia do dinheiro nesta conta <b style="font-size: 21px;">0006.0000.1884.5379.3011.5</b></li>
                <li>Enviar o comprovativo de transferencia no WhatsApp <b style="font-size: 21px;">947545468</b></li>
                <li>Vais receber uma senha que vais colocar no site.</li>
                <li>Selecione o comprovativo em <b>pdf</b></li>
                <li>Clicar em verificar.</li>
                <li>Aguardar a mensagem</li>
            </ol>
        </div>

        <div class="sponsors">
            <div class="sponsor">
                <img src="imgVerificador/367734362_6545594798890070_6416823727582877390_n.jpeg">
                <p style="color: white;">SmartSchool</p>
            </div>
            <div class="sponsor">
                <img src="imgVerificador/7770575259_1730326590.jpeg" alt="Patrocinador 3">
                <p style="color: white;">Marpine</p>
            </div>
            <div class="sponsor">
                <img src="imgVerificador/7685236708_1730327160.20.44.jpeg" alt="Patrocinador 2">
                <p style="color: white;">Psicologia nas Comunidades</p>
            </div>
        </div>
        
        <div class="socials">
            <p>Nos siga nas redes sociais:<br>Paulo Sermão</p>
            <a href="https://web.facebook.com/paulo.sermao" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/733/733547.png" alt="Facebook">
            </a>
            <a href="https://www.instagram.com/paulo_sermao/" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/733/733558.png" alt="Instagram">
            </a>
            <a href="https://www.linkedin.com/in/paulo-serm%C3%A3o-2a96411b6/" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/733/733561.png" alt="LinkedIn">
            </a>
            <a href="https://www.tiktok.com/@paulosermao" target="_blank">
                <img src="https://cdn-icons-png.flaticon.com/512/3046/3046121.png" alt="TikTok">
            </a>
        </div>
    </div>
</body>
</html>